
;;########################################################################
;; homplg.lsp
;; Homals code by de Leeuw, Bond and ...
;; ViSta adaptation by Ruben Ledesma and Pedro Valero 2000
;; ViSta Plugin for Homgeneity Analysis.
;; adapted from clustplg.lsp by Pedro Valero
;;########################################################################


;(require "vista")

;STEP 1: DEFINE THE SEVEN LOCAL VARIABLES 
;        USED TO PREPARE THE PLUGIN ENVIRONMENT

(let ((plugin-subdirectory "homals")
      (plugin-file         "hom-main.lsp")
      (menu-item-title     "Homogeneity Analysis")
      (tool-name           "Homals")
      (model-prefix        "HOM")
      (ok-data-types     '("multivariate" "category" ))
      (ok-variable-types '(category)))
    (send *vista* :prepare-plugin-environment
        plugin-subdirectory
        plugin-file 
        menu-item-title
        tool-name
        model-prefix
        ok-data-types 
        ok-variable-types))



  ;; PLUGIN STEP 2: PLUGIN LOADER FUNCTION
  

(defun homogeneity-analysis
  (&key
   (data *current-data*)    ; universal plugin keyword
   (dialog nil)             ; universal plugin keyword
   (p 3 p-used?)            ; computing dimensions 
   (dimensions 3 used?)     ; alias of p
   (iterations 100 itused?) ; alias of itmax
   (itmax 100 itmaxused?)   ; iterations
   (eps-0 0.0001)   ; number of decimals for function change (to convergence)
   (eps-1 0.0001)   ; number of decimals for solution change (to convergence)
   )
"Args: &key dimensions iterations eps-0 eps-1 data dialog
ViSta plugin to perform homogeneity analysis (also called multiple correspondance analysis) on n-way frequency data. Analysis is performed in a space with DIMENSIONS dimensionality. The analysis methods iterate for a maximum number of ITERATIONS, with EPS-0 and EPS-1 specifying values for the minimum change (epison) in convergence according to two different stopping rules (eps-0 is number of decimals for function change and eps-1 is number of decimals for solution change)."
  
    (format t "; CopyRt: HOMALS Copyright (c) 1995, by Jan de Leeuw~%;           Plugin interface by Pedro Valero and Ruben Ledesma~%> ")

  (load *homals-plugin-constructor-file*)

  (when (and p-used? used? (/= p dimensions))
        (error "HOMALS: You cannot use both the p and the dimensions arguments."))
  
  (when (and itused? itmaxused? (/= iterations itmax))
        (error "HOMALS: You cannot use both the iterations and the itmax arguments."))
  
  (when used? (setf p dimensions))
  (when itused? (setf itmax iterations))
  
  (homogeneity-analysis
   :data data
   :dialog dialog
   :p p
   :itmax itmax
   :eps-0 eps-0
   :eps-1 eps-1)

  )

